<?php namespace Visiosoft\SiteModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\SiteModule\Addon\Contract\AddonRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Traits\CheckAddonSiteTrait;

class AddonsController extends ResourceController
{
    use CheckAddonSiteTrait;

    private $addon;
    private $ad;
    private $site;
    private $cf;

    public function __construct(
        AddonRepositoryInterface $addon,
        CustomFieldRepositoryInterface $cf,
        AdvRepositoryInterface $ad,
        SiteRepositoryInterface $site)
    {
        $this->addon = $addon;
        $this->ad = $ad;
        $this->site = $site;
        $this->cf = $cf;
    }

    public function AddCart()
    {
        $request = request()->all();

        $site = $this->site->find($request['site']);

        $addon_detail = $this->ad->find($request['addon']);

        $addon_slug = $this->cf->getAdValueByCustomFieldSlug('addon_composer_name', $request['addon']);


        if ($site and $site->status == "completed" and $addon_slug) {

            $is_addon_installed = $this->addon->isAddonInstalled($addon_slug,$site->id);

            if (!$is_addon_installed) {

                $addonRecord = $this->addon->createAddonForCart($site, $addon_slug, $addon_detail);

                $addonRecord->name = $addon_detail->name;
                $addonRecord->price = $addon_detail->price;
                $addonRecord->currency = $addon_detail->currency;
                $cart = $this->dispatch(new GetCart());
                $cart->add($addonRecord, 1, $site->subdomain_name . "." . $site->type);
                return redirect('cart');
            }
            $this->messages->error(trans('visiosoft.module.site::message.already_installed_addon'));
        }
        return back();
    }

    public function checkAddon()
    {
        $this->checkInstalledAddon();
    }
}
