<?php namespace Visiosoft\SiteModule\Site\Event;

use Anomaly\UsersModule\User\UserModel;
use Visiosoft\SiteModule\Site\SiteModel;

class CreateSite
{
    /**
     * @var SiteModel
     */
    private $site;

    /**
     * CreateSite constructor.
     * @param SiteModel $site
     */
    public function __construct($siteParams)
    {
        $this->site = $siteParams;
    }

    /**
     * @return \Anomaly\Streams\Platform\Entry\EntryPresenter|mixed
     */
    public function getAssign()
    {
        $user = new UserModel();
        return $user->newQuery()->find($this->site['assign']);
    }

    public function getSubdomain()
    {
        return $this->site['subdomain_name'];
    }

    public function getPassword()
    {
        return $this->site['password'];
    }

    public function getType()
    {
        return $this->site['type'];
    }
}
