<?php namespace Visiosoft\SiteModule\Addon\Listener;

use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\OrdersModule\Order\Events\OrderApproved;
use Visiosoft\SiteModule\Addon\Contract\AddonRepositoryInterface;
use Visiosoft\SiteModule\Bundle\Contract\BundleRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\AddMultipleAddonSite;

class OrderApproveListener
{
	private $addon;
	private $bundle;
	public $cf;
	private $siteRepository;
	private $message;
	private $install_addons = [];

	public function __construct
	(
		AdvRepositoryInterface $advRepository,
		AddonRepositoryInterface $addon,
		BundleRepositoryInterface $bundle,
		CustomFieldRepositoryInterface $cf,
		SiteRepositoryInterface $siteRepository,
		MessageBag $message
	)
	{
		$this->addon = $addon;
		$this->bundle = $bundle;
		$this->cf = $cf;
		$this->siteRepository = $siteRepository;
		$this->message = $message;
	}

	public function handle(OrderApproved $event)
	{
		if ($order_option = $event->getOrder()->order_option) {
			$option = json_decode($order_option, true);

			if (array_key_exists('site_select', $option) && $site = $this->siteRepository->find($option['site_select'])) {
				foreach ($event->getOrderDetail() as $order) {
					if ($order->item_type === 'bundle') {
						$bundles = $this->bundle->find($order->item_id);
						foreach ($bundles->addons as $addon) {
							$this->installAddon($addon, $site);
						}
					} elseif ($order->item_type === 'adv') {
						$this->installAddon($order, $site);
					}
				}
				if (count($this->install_addons)) {
					event(new AddMultipleAddonSite($site, $this->install_addons));
				}
			}
		}
	}

	public function installAddon($order, $site)
	{
		if ($is_addon = $this->cf->getAdValueByCustomFieldSlug('addon_composer_name', $order->item_id ?? $order->id)) {
			if (!$this->addon->isAddonInstalled($is_addon, $site->getId())) {
				$addon_array = explode('-', $is_addon);
				$this->install_addons[] = ['type' => $addon_array[1], 'name' => $addon_array[0]];

				$this->addon->create([
					'subdomain' => $site,
					'addon' => $is_addon,
					'payment' => true,
					'installed' => 'pending',
					'entry_id' => $order,
					'entry_type' => 'Visiosoft\AdvsModule\Adv\AdvModel'
				]);
			}
			$this->message->success(trans('visiosoft.module.site::message.addAddon'));
		} else {
			$this->message->error(trans('visiosoft.module.site::message.error_addon_slug'));
		}
	}
}
