<?php namespace Visiosoft\SiteModule\Site\Table\Query;

use Anomaly\Streams\Platform\Ui\Table\Component\Filter\Contract\FilterInterface;
use Illuminate\Database\Eloquent\Builder;
use Visiosoft\SubscriptionsModule\Subscription\Contract\SubscriptionRepositoryInterface;

class SubscriptionFilterQuery
{
    public function handle(Builder $query, FilterInterface $filter, SubscriptionRepositoryInterface $subscription)
    {
        $operator = ($filter->getValue() === "active") ? '>' : '<';

        $subscriptions = $subscription
            ->getWithExpired(date('Y-m-d H:i:s'),$operator)
            ->pluck('id')->all();

        $query->whereIn('subscription_id', $subscriptions);
    }
}
