<?php namespace Visiosoft\SiteModule\Site\Listener;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SubscriptionsModule\Subscription\Event\SubscriptionCreated;

class CreatedNewSubscription
{
    private $site;
    private $user;

    public function __construct(SiteRepositoryInterface $site, UserRepositoryInterface $user)
    {
        $this->site = $site;
        $this->user = $user;
    }

    public function handle(SubscriptionCreated $event)
    {
        $subscription = $event->getSubscription();
        $password = str_random(8);
        $user = $subscription->assign;

        $site = $this->site->createSite($user->subdomain, $password, $user);
        return $site;

    }
}
