<?php namespace Visiosoft\SiteModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Visiosoft\SiteModule\Site\AddAddonForm\AddAddonFormBuilder;
use Visiosoft\SiteModule\Site\Form\SiteFormBuilder;
use Visiosoft\SiteModule\Site\Table\SiteTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class SiteController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param SiteTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(SiteTableBuilder $table)
    {
        $table->addButtons([
            'addAddon' => [
                'text' => 'visiosoft.module.site::button.addAddon',
                'href' => route('site::addAddon') . '?site={entry.id}',
                'icon' => 'fa fa-plus',
                'type' => 'info'
            ],
            'status' => [
                'text' => function (EntryInterface $entry) {
                    if ($entry->enabled) {
                        return "visiosoft.module.site::button.active";
                    }
                    return "visiosoft.module.site::button.pending";
                },
                'href' => "#",
                'type' => function (EntryInterface $entry) {
                    if ($entry->enabled) {
                        return "success";
                    }
                    return "default";
                },
                'icon' => function (EntryInterface $entry) {
                    if ($entry->enabled) {
                        return "fa fa-check";
                    }
                    return "fa fa-clock-o";
                },
            ],
        ]);
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param SiteFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(SiteFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * @param AddAddonFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function addAddon(AddAddonFormBuilder $form)
    {
        return $form->render();
    }
}
