<?php namespace Visiosoft\SiteModule\Addon\Listener;

use Illuminate\Support\Facades\Auth;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\CartsModule\Cart\Event\PaymentPending;
use Visiosoft\SiteModule\Addon\Contract\AddonRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\SiteModel;

class PaymentPendingAddon
{
    private $ad;
    private $site;
    private $siteRepository;
    private $addon;


    public function __construct(AdvRepositoryInterface $ad, SiteModel $site, SiteRepositoryInterface $siteRepository, AddonRepositoryInterface $addon)
    {
        $this->ad = $ad;
        $this->site = $site;
        $this->siteRepository = $siteRepository;
        $this->addon = $addon;
    }

    public function handle(PaymentPending $event)
    {
        foreach ($event->getOrderDetail() as $order) {
            if ($order->item_type == "adv" and !is_null($ad = $this->ad->find($order->item_id))) {
                if (!is_null($site = $this->siteRepository->findBySubdomain(Auth::user()->subdomain))) {
                    $site = $this->site->find($site->id);
                    $this->addon->create([
                        'subdomain' => $site,
                        'addon' => str_replace('_', '-', $ad->slug),
                        'payment' => false
                    ]);
                }
            }
        }

    }
}
