<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Anomaly\UsersModule\User\UserModel;
use Visiosoft\SiteModule\Site\SiteModel;

class VisiosoftModuleSiteCreateSiteFields extends Migration
{

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'subdomain_name' => 'anomaly.field_type.text',
        'assign' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => UserModel::class,
            ]
        ],
        'password' => 'anomaly.field_type.text',
        'suspend_at' => 'anomaly.field_type.datetime',
        'update_at' => 'anomaly.field_type.datetime',
        'enabled' => [
            'type' => 'anomaly.field_type.boolean',
            'config' => [
                'default_value' => false,
            ],
        ],
        'subdomain' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => SiteModel::class,
            ]
        ],
        'domain' => [
            "type" => "anomaly.field_type.url",
        ],
        'addon' => [
            'type' => 'anomaly.field_type.text',
        ],
        'payment' => [
            'type' => 'anomaly.field_type.boolean',
            'config' => [
                'default_value' => true,
            ],
        ],
    ];

}
