<?php namespace Visiosoft\SiteModule\Site\Table;

use Visiosoft\SiteModule\Domain\Contract\DomainRepositoryInterface;
use Visiosoft\SiteModule\Site\Table\Query\DomainFilterQuery;
use Visiosoft\SiteModule\Site\Table\Query\RemainingFilterQuery;
use Visiosoft\SiteModule\Site\Table\Query\SubscriptionFilterQuery;

class SiteTableFilters
{
    public function handle(SiteTableBuilder $builder)
    {
        $builder->setFilters(
            [
                'search' => [
                    'fields' => [
                        'subdomain_name',
                    ],
                ],
                'domain' => [
                    'filter' => 'select',
                    'query' => DomainFilterQuery::class,
                    'options' => function (DomainRepositoryInterface $domain) {
                        $domains = $domain->newQuery()
                            ->pluck('domain', 'id')
                            ->all();

                        return $domains;
                    }
                ],
                'subscription' => [
                    'placeholder' => false,
                    'filter' => 'select',
                    'query' => SubscriptionFilterQuery::class,
                    'options' => [
                        'active' => 'visiosoft.module.site::field.active',
                        'expired' => 'visiosoft.module.site::field.expired'
                    ],
                ],
                'remaining_time' => [
                    'filter' => 'input',
                    'query' => RemainingFilterQuery::class
                ],
                'updated_at',
                'type'
            ]
        );
    }
}
