<?php namespace Visiosoft\SiteModule\Site\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;
use Visiosoft\SiteModule\Site\Table\Handler\Delete;
use Visiosoft\SiteModule\Site\Table\Handler\Suspend;
use Visiosoft\SiteModule\Site\Table\Handler\unSuspend;
use Visiosoft\SiteModule\Site\Table\Handler\Update;

class SiteTableBuilder extends TableBuilder
{

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [];

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [
        'search' => [
            'fields' => [
                'subdomain_name',
            ],
        ],
        'updated_at',
        'type'
    ];

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [
    ];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'update' => [
            'handler' => Update::class,
            'icon' => 'refresh',
            'text' => 'visiosoft.module.site::button.update',
            'type' => 'info'
        ],
        'suspend' => [
            'handler' => Suspend::class,
            'text' => 'visiosoft.module.site::button.suspend',
            'icon' => 'fa fa-eye-slash'
        ],
        'unSuspend' => [
            'handler' => unSuspend::class,
            'text' => 'visiosoft.module.site::button.unSuspend',
            'icon' => 'fa fa-eye',
            'type' => 'primary'
        ]
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [];

}
