<?php namespace Visiosoft\SiteModule\Site;

use Anomaly\Streams\Platform\Assignment\AssignmentModelTranslation;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Field\FieldModelTranslation;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;

class SiteSeeder extends Seeder
{

    public function run(
        FieldRepositoryInterface $fieldRepository,
        AssignmentRepositoryInterface $assignmentRepository,
        FieldModelTranslation $fieldModelTranslation,
        StreamRepositoryInterface $streamRepository,
        AssignmentModelTranslation $assignmentModelTranslation

    )
    {
        //Find Stream
        $stream = $streamRepository->findBy('slug', 'users');

        $subdomain = [
            'name' => trans('visiosoft.module.site::field.subdomain_name.name'),
            'slug' => 'subdomain',
            'type' => 'anomaly.field_type.text',
        ];

//        Remove Old
        $field = $fieldRepository
            ->newQuery()
            ->where('slug', $subdomain['slug'])
            ->where('namespace', 'users')
            ->first();

        if (!is_null($field)) {
            $fieldModelTranslation->newQuery()->where('field_id', $field->id)->delete();


            //Remove old Assigment In Users
            $assignment = $assignmentRepository
                ->newQuery()
                ->where('stream_id', $stream->id)
                ->where('field_id', $field->id)
                ->first();

            //Remove old Assigment Translations In Users
            $assignmentModelTranslation
                ->newQuery()
                ->where('assignment_id', $assignment->id)
                ->delete();

            $assignment->delete();
            $field->delete();
        }

        $field = $fieldRepository->create(
            [
                'name' => $subdomain['name'],
                'namespace' => 'users',
                'slug' => $subdomain['slug'],
                'type' => $subdomain['type'],
                'locked' => 0
            ]
        );

        $assignmentRepository->create([
            'stream_id' => $stream->id,
            'field_id' => $field->id
        ]);

    }

}
