<?php namespace Visiosoft\SiteModule\Site\Form;

use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\SiteModule\Site\Event\CreateSite;


class SiteFormHandler
{
    public function handle(SiteFormBuilder $builder,MessageBag $message)
    {

        if (!$builder->canSave()) {
            return;
        }
        $site = $builder->getPostData();
        $newSite = event(new CreateSite($site));

        $return = array_first($newSite);

        if($return['status'] !== true)
        {
            $message->error([$return['message']]);
            return redirect('/admin/site');
        } else {
            $builder->saveForm();

            $builder->getFormEntry();
        }
    }
}
