<?php namespace Visiosoft\SiteModule\Site\Table\Query;

use Anomaly\Streams\Platform\Ui\Table\Component\Filter\Contract\FilterInterface;
use Illuminate\Database\Eloquent\Builder;
use Visiosoft\SubscriptionsModule\Subscription\Contract\SubscriptionRepositoryInterface;

class RemainingFilterQuery
{
    public function handle(Builder $query, FilterInterface $filter, SubscriptionRepositoryInterface $subscription)
    {
        $filter_value = $filter->getValue();

        if (!(int)$filter_value) {
            return null;
        }

        $remaining_filter_date = now()->addDays($filter_value)->format('Y-m-d');

        $subscriptions = $subscription->getWithExpired($remaining_filter_date)
            ->pluck('id')->all();

        $query->whereIn('subscription_id', $subscriptions);
    }
}
