<?php namespace Visiosoft\SiteModule\Site\Listener;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SubscriptionsModule\Subscription\Event\SubscriptionDeleted;

class DeletedSubscription
{
    private $site;
    private $user;

    public function __construct(SiteRepositoryInterface $site, UserRepositoryInterface $user)
    {
        $this->site = $site;
        $this->user = $user;
    }

    public function handle(SubscriptionDeleted $event)
    {
        $subscription = $event->getSubscription();
        $user = $subscription->assign;

        $sites = $this->site->findByAssing($user->id);

        foreach ($sites as $site) {
            $this->site->deleteSite($site->id);
        }
    }
}
