<?php namespace Visiosoft\SiteModule\Addon\Table\Handler;

use Anomaly\Streams\Platform\Ui\Table\Component\Action\ActionHandler;
use Visiosoft\SiteModule\Addon\Table\AddonTableBuilder;
use Visiosoft\SiteModule\Site\Event\DeleteAddonSite;


class Delete extends ActionHandler
{
    public function handle(AddonTableBuilder $builder, array $selected)
    {
        $model = $builder->getTableModel();
        foreach ($selected as $id) {

            $addon = $model->newQuery()->find($id);
            if (!is_null($addon)) {
                $addon->update
                ([
                    'deleted_at' => date('Y-m-d H:i:s'),
                ]);
                event(new DeleteAddonSite($addon));
            }

        }
        if ($selected) {
            $this->messages->success(trans('visiosoft.module.site::message.deleted', ['count' => count($selected)]));
        }
    }
}