<?php namespace Visiosoft\SiteModule\Addon\Listener;

use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\CartsModule\Cart\Event\PaymentSuccess;
use Visiosoft\SiteModule\Addon\Contract\AddonRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\AddAddonSite;
use Visiosoft\SiteModule\Site\SiteModel;

class PaymentSuccessAddon
{
    private $ad;
    private $site;
    private $siteRepository;
    private $addon;


    public function __construct(
        AdvRepositoryInterface $ad,
        SiteModel $site,
        SiteRepositoryInterface $siteRepository,
        AddonRepositoryInterface $addon
    )
    {
        $this->ad = $ad;
        $this->site = $site;
        $this->siteRepository = $siteRepository;
        $this->addon = $addon;
    }

    public function handle(PaymentSuccess $event)
    {
        foreach ($event->getOrderDetail() as $order) {
            if ($order->item_type == "site" and !is_null($addon = $this->addon->find($order->item_id))) {
                event(new AddAddonSite($addon->subdomain, $addon->addon));
                $addon->update([
                    'payment' => true,
                    'installed' => 'pending'
                ]);
            }
        }

    }
}
