<?php namespace Visiosoft\SiteModule\Site\Table\Handler;

use Anomaly\Streams\Platform\Ui\Table\Component\Action\ActionHandler;
use Visiosoft\SiteModule\Site\Event\DeleteSite;
use Visiosoft\SiteModule\Site\Table\SiteTableBuilder;


class Delete extends ActionHandler
{
    public function handle(SiteTableBuilder $builder, array $selected)
    {
        $model = $builder->getTableModel();
        foreach ($selected as $id) {

            $site = $model->newQuery()->find($id);
            if (!is_null($site)) {
                $site->update
                ([
                    'deleted_at' => date('Y-m-d H:i:s'),
                ]);
                event(new DeleteSite($site));
            }

        }
        if ($selected) {
            $this->messages->success(trans('visiosoft.module.site::message.deleted', ['count' => count($selected)]));
        }
    }
}