<?php namespace Visiosoft\SiteModule\Site;

use Anomaly\UsersModule\User\UserModel;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use Visiosoft\SiteModule\Site\Event\CreateSite;

class SiteRepository extends EntryRepository implements SiteRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var SiteModel
     */
    protected $model;

    /**
     * Create a new SiteRepository instance.
     *
     * @param SiteModel $model
     */
    public function __construct(SiteModel $model)
    {
        $this->model = $model;
    }

    /**
     * @param $subdomain
     * @return mixed
     */
    public function findBySubdomain($subdomain)
    {
        if (!is_null($sites = $this->newQuery()->where('subdomain_name', $subdomain)->get())) {
            return $sites->first();
        }
        return null;
    }

    /**
     * @param $subdomain
     * @param $password
     * @param UserModel $user
     * @return \Illuminate\Database\Eloquent\Builder|\Illuminate\Database\Eloquent\Model
     */
    public function createSite($subdomain, $password, UserModel $user)
    {
        $site = $this->newQuery()->create(
            [
                'subdomain_name' => $subdomain,
                'assign' => $user,
                'password' => $password,
            ]
        );
        event(new CreateSite($site));
        return $site;
    }
}
