<?php namespace Visiosoft\SiteModule\Site\Listener;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\PaddleModule\Subscription\Event\SubscriptionCreate;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\CreateSite;

class CreateSubscription
{
    private $site;
    private $user;

    public function __construct(SiteRepositoryInterface $site, UserRepositoryInterface $user)
    {
        $this->site = $site;
        $this->user = $user;
    }

    public function handle(SubscriptionCreate $event)
    {
        $siteParameters = $event->getResponse()->passthrough;
        $siteParameters = str_replace('\'','"',$siteParameters);
        $siteParameters = json_decode($siteParameters,true);
        $password = str_random(8);
        $user = $this->user->findByEmail($siteParameters['email']);
        if (!is_null($user)) {
            $this->site->createSite($siteParameters['subdomain'], $password, $user);
        }
    }
}
