<?php namespace Visiosoft\SiteModule\Site\Form;

class SiteFormFields
{
    public function handle(SiteFormBuilder $builder)
    {
        if ($builder->getFormMode() === 'edit') {
            $builder->setFields([
                'status' => [
                    'type' => 'anomaly.field_type.select',
                    'config' => [
                        'options' => [
                            'completed' => 'module::field.completed',
                            'error' => 'module::field.error',
                            'pending' => 'module::field.pending',
                            'incomplete' => 'module::field.incomplete',
                        ],
                    ],
                ],
                'message',
                'update_at',
                'suspend_at',
                'deletedCwp',
                'assign',
                'password' => [
                    'disabled' => true,
                ],
                'auto_refresh' => [
                    'disabled',
                    'attributes' => [
                        'class' => 'd-none'
                    ],
                ],
                'reinstall_addons',
            ]);
        } else {
            $builder->setFields([
                'subdomain_name' => [
                    'config' => [
                        'max' => 8,
                    ],
                ],
                'type' => [
                    'type' => 'anomaly.field_type.select',
                    'config' => [
                        'options' => function () {
                            $domains = setting_value('visiosoft.module.site::demo_domains');
                            return array_combine($domains, $domains);
                        }
                    ]
                ],
                'assign',
                'password',
                'auto_refresh',
                'reinstall_addons',
            ]);
        }

    }
}
