<?php namespace Visiosoft\SiteModule\Site\Table;

use Visiosoft\SiteModule\Domain\Contract\DomainRepositoryInterface;
use Visiosoft\SiteModule\Site\Table\Query\DeletedCWPFilterQuery;
use Visiosoft\SiteModule\Site\Table\Query\DomainFilterQuery;
use Visiosoft\SiteModule\Site\Table\Query\RemainingFilterQuery;
use Visiosoft\SiteModule\Site\Table\Query\SubscriptionFilterQuery;

class SiteTableFilters
{
    public function handle(SiteTableBuilder $builder)
    {
        $filters =  [
            'search' => [
                'fields' => [
                    'subdomain_name',
                ],
            ],
            'domain' => [
                'filter' => 'select',
                'query' => DomainFilterQuery::class,
                'options' => function (DomainRepositoryInterface $domain) {
                    $domains = $domain->newQuery()
                        ->pluck('domain', 'id')
                        ->all();

                    return $domains;
                }
            ],
            'subscription' => [
                'placeholder' => false,
                'filter' => 'select',
                'query' => SubscriptionFilterQuery::class,
                'options' => [
                    'active' => 'visiosoft.module.site::field.active',
                    'expired' => 'visiosoft.module.site::field.expired'
                ],
            ],
            'remaining_time' => [
                'filter' => 'input',
                'query' => RemainingFilterQuery::class
            ],
            'updated_at',
            'assign' => [
                'filter' => 'select'
            ],
            'type',
            'deleted_server' => [
                'placeholder' => false,
                'filter' => 'select',
                'query' => DeletedCWPFilterQuery::class,
                'options' => [
                    'deleted' => 'visiosoft.module.site::field.deleted',
                    'suspended' => 'visiosoft.module.site::field.suspended'
                ],
            ]
        ];

        $builder->setFilters($filters);
    }
}
