<?php namespace Visiosoft\SiteModule\Site\Table\Handler;

use Anomaly\Streams\Platform\Ui\Table\Component\Action\ActionHandler;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Jobs\ExtendSite;

class Extend extends ActionHandler
{
    public function handle(SiteRepositoryInterface $siteRepository, array $selected)
    {
        //number of days to be extended
        $days = setting_value('visiosoft.module.site::extend_day', 30);
        foreach ($selected as $id) {
            if ($site = $siteRepository->find($id)) {
                ExtendSite::dispatch($site, $days);
            }
        }

        if ($selected) {
            $this->messages->success(trans('visiosoft.module.site::message.extended', ['count' => count($selected)]));
        }
    }
}