<?php namespace Visiosoft\SiteModule\Site\Table\Handler;

use Anomaly\Streams\Platform\Ui\Table\Component\Action\ActionHandler;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;

class Delete extends ActionHandler
{
    public function handle(SiteRepositoryInterface $siteRepository, array $selected)
    {
        foreach ($selected as $id) {

            if ($site = $siteRepository->findTerminate($id)) {

                \Visiosoft\SiteModule\Site\Jobs\DeleteSite::dispatch($site);

                $url = $site->getUrl();

                $this->messages->success(trans('visiosoft.module.site::message.deleted', ['name' => $url]));

                $site->updateDeleteStatus('pending');
            }
        }
    }
}