<?php namespace Visiosoft\SiteModule\Notifications;

use Anomaly\Streams\Platform\Notification\Message\MailMessage;
use Anomaly\UsersModule\User\Contract\UserInterface;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;


class WelcomeUser extends Notification implements ShouldQueue
{

    use Queueable;


    public $redirect;


    public function __construct($redirect = '/')
    {
        $this->redirect = $redirect;
    }

    public function via(UserInterface $notifiable)
    {
        return ['mail'];
    }


    public function toMail(UserInterface $notifiable)
    {
        $data = $notifiable->attributesToArray();

        return (new MailMessage())
            ->view('visiosoft.module.site::notifications.welcome_user')
            ->subject(trans('visiosoft.module.site::notification.welcome_user.subject', $data))
            ->greeting(trans('visiosoft.module.site::notification.welcome_user.greeting', $data))
            ->line(trans('visiosoft.module.site::notification.welcome_user.instructions', $data))
            ->action(
                trans('visiosoft.module.site::notification.welcome_user.button', $data),
                $this->redirect != '/' ?$this->redirect: 'https://'.setting_value('streams::domain', 'ocify.co')
            );
    }
}