<?php namespace Visiosoft\SiteModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Visiosoft\ConnectModule\Resource\ResourceBuilder;

class ApiController extends ResourceController
{
    public function detail(ResourceBuilder $resources)
    {
        return $resources
            ->setFunction('detail')
            ->setOption('read', true)
            ->setOption('paginate', false)
            ->setOption('parameters', $this->request->all())
            ->response('site', 'site');
    }

    public function addDomain(ResourceBuilder $resources)
    {
        return $resources
            ->setFunction('add')
            ->setOption('read', true)
            ->setOption('paginate', false)
            ->setOption('parameters', $this->request->all())
            ->response('site', 'domain');
    }

    public function listDomain(ResourceBuilder $resources)
    {
        return $resources
            ->setFunction('list')
            ->setOption('read', true)
            ->setOption('parameters', $this->request->all())
            ->response('site', 'domain');
    }

    public function addDomainSSL(ResourceBuilder $resources)
    {
        return $resources
            ->setFunction('addSSL')
            ->setOption('paginate', false)
            ->setOption('read', true)
            ->setOption('parameters', $this->request->all())
            ->response('site', 'domain');
    }

}
