<?php namespace Visiosoft\SiteModule\Domain\Table;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Visiosoft\SiteModule\Domain\Contract\DomainRepositoryInterface;
use Visiosoft\SubscriptionsModule\Subscription\Contract\SubscriptionRepositoryInterface;

class DomainTableColumns
{
    public function handle(DomainTableBuilder $builder)
    {
        $builder->setColumns([
            'domain' => [
                'value' => function (EntryInterface $entry) {
                    $url = $entry->getDomain();

                    $verify = $entry->verify ? 'fa-check text-success' : 'fa-times text-danger';
                    $ssl = $entry->verify_ssl ? 'fa-lock text-success' : 'fa-unlock-alt text-danger';

                    $link = '<a href="https://' . $url . '" target="_blank">' . $url . '</a><i class="fa ' . $verify . ' pl-1"></i><i class="fa ' . $ssl . '"></i>';

                    return $link;
                },
            ],
            'subdomain'
        ]);
    }
}
