var searchParams = new URLSearchParams(window.location.search)

if (searchParams.has('site')) {
    $.ajax({
        type: 'GET',
        async: false,
        url: '/admin/ajax/getAddonsForSite/' + searchParams.get('site'),
        success: function (e) {
            $.each(e.addons, function (a, b) {
                $("select[name='addon[]']").append("<option value='" + a + "' selected>" + b + "</option>");
            });
            $("select[name='addon[]']").trigger('change');
        },
    });
}


$(document).ready(function () {
    $("select[name='addon[]']").select2({
        ajax: {
            url: "/admin/site/ajax/search-addon",
            type: "GET",
            data: function (params) {
                return {
                    q: params.term,
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            },
            cache: true
        },
        allowClear: true,
        theme: "classic",
        placeholder: "All",
        minimumInputLength: 3
    });
});