<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleSiteMakeTranslatable extends Migration
{

    protected $entries = [
        "bundles" => [
            "name",
            "icon",
            "sale_icon",
        ],
    ];


    public function up()
    {
        foreach ($this->entries as $stream_key => $fields) {
            foreach ($fields as $field) {

                $field = $this->fields()->findBySlugAndNamespace($field, 'site');
                $stream = $this->streams()->findBySlugAndNamespace($stream_key, 'site');

                if ($field && $stream) {
                    $this->assignments()->findByStreamAndField($stream, $field)->setAttribute('translatable', true)->save();
                }
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        foreach ($this->entries as $stream_key => $fields) {
            foreach ($fields as $field) {

                $field = $this->fields()->findBySlugAndNamespace($field, 'site');
                $stream = $this->streams()->findBySlugAndNamespace($stream_key, 'site');

                if ($field && $stream) {
                    $this->assignments()->findByStreamAndField($stream, $field)->setAttribute('translatable', false)->save();
                }
            }
        }
    }
}
