<?php namespace Visiosoft\SiteModule\Site\Table\Handler;

use Anomaly\Streams\Platform\Message\MessageBag;
use Anomaly\Streams\Platform\Ui\Table\Component\Action\ActionHandler;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Jobs\SoftDeleteSite;


class SoftDelete extends ActionHandler
{
    public function handle(SiteRepositoryInterface $siteRepository, array $selected, MessageBag $message)
    {
        foreach ($selected as $id) {
            $site = $siteRepository->find($id);
            if ($site) {
                SoftDeleteSite::dispatch($site);
                $site->delete();
            }
        }
    }
}