<?php namespace Visiosoft\SiteModule\Site\Form;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;

class SiteFormFields
{
    public function handle(SiteFormBuilder $builder)
    {
        $fields = [
            'reinstall_addons',
            'backup_status',
            'assign' => [
                'config' => [
                    'default_value' => Auth::id()
                ]
            ],
            'locale' => [
                'type' => 'anomaly.field_type.text',
                'label' => 'visiosoft.module.site::field.lang.name',
                'config' => [
                    'default_value' => 'en'
                ]
            ],
            'api_token' => [
                'config' => [
                    'default_value' => Str::random(24)
                ]
            ],
        ];
        if ($builder->getFormMode() === 'edit') {
            $builder->setFields(array_merge([
                'status' => [
                    'type' => 'anomaly.field_type.select',
                    'config' => [
                        'options' => [
                            'completed' => 'module::field.completed',
                            'error' => 'module::field.error',
                            'pending' => 'module::field.pending',
                            'incomplete' => 'module::field.incomplete',
                        ],
                    ],
                ],
                'message',
                'update_at',
                'suspend_at',
                'deletedCwp',
                'password' => [
                    'disabled' => true,
                ],
                'node' => [
                    'disabled',
                ],
                'auto_refresh' => [
                    'disabled',
                    'attributes' => [
                        'class' => 'd-none'
                    ],
                ],
            ], $fields));
        } else {
            $builder->setFields(array_merge([
                'subdomain_name' => [
                    'type' => 'anomaly.field_type.slug',
                    'config' => [
                        'type' => '-',
                        'max' => 8,
                    ],
                ],
                'type' => [
                    'type' => 'anomaly.field_type.select',
                    'config' => [
                        'default_value' => setting_value('visiosoft.module.site::default_domain'),
                        'options' => function () {
                            $domains = setting_value('visiosoft.module.site::demo_domains');
                            return array_combine($domains, $domains);
                        }
                    ]
                ],
                'node' => [
                    'value' => function () {
                        return setting_value('visiosoft.module.site::default_node_server');
                    },
                ],
                'app' => [
                    'config' => [
                        'default_value' => setting_value('visiosoft.module.site::default_app')
                    ],
                ],
                'password',
                'auto_refresh',
            ], $fields));
        }

    }
}
