<?php namespace Visiosoft\SiteModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\OrdersModule\Order\Events\OrderApproved;
use Visiosoft\SiteModule\StoreDomain\Contract\StoreDomainRepositoryInterface;
use Visiosoft\SiteModule\StoreDomain\StoreDomainRepository;
use Anomaly\Streams\Platform\Model\Site\SiteStoreDomainEntryModel;
use Visiosoft\SiteModule\StoreDomain\StoreDomainModel;
use Visiosoft\SiteModule\Bundle\Contract\BundleRepositoryInterface;
use Visiosoft\SiteModule\Bundle\BundleRepository;
use Anomaly\Streams\Platform\Model\Site\SiteBundlesEntryModel;
use Visiosoft\SiteModule\Bundle\BundleModel;
use Visiosoft\CartsModule\Cart\Event\PaymentSuccess;
use Visiosoft\SiteModule\Addon\Contract\AddonRepositoryInterface;
use Visiosoft\SiteModule\Addon\AddonRepository;
use Anomaly\Streams\Platform\Model\Site\SiteAddonEntryModel;
use Visiosoft\SiteModule\Addon\AddonModel;
use Visiosoft\SiteModule\Addon\Listener\PaymentSuccessAddon;
use Visiosoft\SiteModule\Domain\Contract\DomainRepositoryInterface;
use Visiosoft\SiteModule\Domain\DomainRepository;
use Anomaly\Streams\Platform\Model\Site\SiteDomainEntryModel;
use Visiosoft\SiteModule\Domain\DomainModel;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Listener\CreatedNewSubscriptionForActivatedUser;
use Visiosoft\SiteModule\Site\Listener\SubscriptionDeleted;
use Visiosoft\SiteModule\Site\Listener\SubscriptionExpired;
use Visiosoft\SiteModule\Site\Listener\SubscriptionSuspended;
use Visiosoft\SiteModule\Site\Listener\SubscriptionUnSuspended;
use Visiosoft\SiteModule\Site\Listener\webhook\CreatedNewSubscriptionForWebhook;
use Visiosoft\SiteModule\Site\Listener\webhook\DeletedSubscriptionForWebhook;
use Visiosoft\SiteModule\Site\Listener\webhook\FailedSubscriptionForWebhook;
use Visiosoft\SiteModule\Site\Listener\webhook\RenewedSubscriptionForWebhook;
use Visiosoft\SiteModule\Site\Listener\webhook\SuspendedSubscriptionForWebhook;
use Visiosoft\SiteModule\Site\Listener\webhook\UpgradeSubscriptionForWebhook;
use Visiosoft\SiteModule\Site\SiteRepository;
use Anomaly\Streams\Platform\Model\Site\SiteSiteEntryModel;
use Visiosoft\SiteModule\Site\SiteModel;
use Visiosoft\SubscriptionsModule\Subscription\Event\DeletedSubscription;
use Visiosoft\SubscriptionsModule\Subscription\Event\ExpiredSubscription;
use Visiosoft\SubscriptionsModule\Subscription\Event\SubscriptionCreatedForActivatedUser;
use Visiosoft\SubscriptionsModule\Subscription\Event\SuspendedSubscription;
use Visiosoft\SubscriptionsModule\Subscription\Event\UnSuspendedSubscription;
use Visiosoft\SubscriptionsModule\Subscription\Event\UpgradeSubscription;
use Visiosoft\SubscriptionsModule\Subscription\Event\webhook\SubscriptionCreatedForWebhook;
use Visiosoft\SubscriptionsModule\Subscription\Event\webhook\SubscriptionDeletedForWebhook;
use Visiosoft\SubscriptionsModule\Subscription\Event\webhook\SubscriptionFailedForWebhook;
use Visiosoft\SubscriptionsModule\Subscription\Event\webhook\SubscriptionRenewedForWebhook;
use Visiosoft\SubscriptionsModule\Subscription\Event\webhook\SubscriptionSuspendForWebhook;

class SiteModuleServiceProvider extends AddonServiceProvider
{
    protected $plugins = [
        SiteModulePlugin::class
    ];

    protected $routes = [
        'admin/site/store_domain' => 'Visiosoft\SiteModule\Http\Controller\Admin\StoreDomainController@index',
        'admin/site/store_domain/create' => 'Visiosoft\SiteModule\Http\Controller\Admin\StoreDomainController@create',

        'admin/site/bundles' => 'Visiosoft\SiteModule\Http\Controller\Admin\BundlesController@index',
        'admin/site/bundles/create' => 'Visiosoft\SiteModule\Http\Controller\Admin\BundlesController@create',
        'admin/site/bundles/edit/{id}' => 'Visiosoft\SiteModule\Http\Controller\Admin\BundlesController@edit',
        'bundle/{id}' => 'Visiosoft\SiteModule\Http\Controller\BundlesController@detail',
        'add-cart/bundle' => [
            'as' => 'visiosoft.module.site::bundle.add_cart',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\BundlesController@addCart',
        ],

        'admin/site/addon' => [
            'as' => 'visiosoft.module.site::admin.addon.list',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\Admin\AddonController@index',
        ],
        'admin/addon/check' => 'Visiosoft\SiteModule\Http\Controller\Admin\AddonController@checkAddon',
        'admin/site/addon/installation/{id}' => 'Visiosoft\SiteModule\Http\Controller\Admin\AddonController@AddonInstall',
        'admin/site/domain' => 'Visiosoft\SiteModule\Http\Controller\Admin\DomainController@index',
        'admin/site/domain/create' => [
            'as' => 'visiosoft.module.site::admin.domain.create',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\Admin\DomainController@create',
        ],
        'admin/site' => 'Visiosoft\SiteModule\Http\Controller\Admin\SiteController@index',
        'admin/site/create' => 'Visiosoft\SiteModule\Http\Controller\Admin\SiteController@create',
        'admin/site/check' => 'Visiosoft\SiteModule\Http\Controller\Admin\SiteController@check',
        'admin/site/{site_id}/send/{template_slug}' => 'Visiosoft\SiteModule\Http\Controller\Admin\SiteController@sendEmail',
        'admin/site/add-addon' => [
            'as' => 'visiosoft.module.site::admin.add.addon',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\Admin\SiteController@addAddon'
        ],
        'profile/mysites/add-domain/{id}' => [
            'as' => 'add-domain',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\SiteController@addDomain',
        ],
        'site/create' => 'Visiosoft\SiteModule\Http\Controller\SiteController@createNew',

        'ajax/registerUser' => [
            'uses' => 'Visiosoft\SiteModule\Http\Controller\SiteController@registerUser',
        ],
        'addon/addCart' => 'Visiosoft\SiteModule\Http\Controller\AddonsController@addCart',
        'admin/ajax/getAddonsForSite/{id}' => 'Visiosoft\SiteModule\Http\Controller\Admin\AddonController@getAddonListForSite',
        'admin/site/complete-on-manuel/{id}' => [
            'as' => 'visiosoft.module.site::admin.complete.on.manuel',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\Admin\SiteController@completeOnManuel',
        ],
        'installation-started' => [
            'as' => 'visiosoft.module.site::installation.started',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\SiteController@installationStarted',
        ],

        //Cron
        'cron/pendingSites' => 'Visiosoft\SiteModule\Http\Controller\SiteController@activateSites',
        'cron/cronGuide' => 'Visiosoft\SiteModule\Http\Controller\SiteController@cronGuide',
        'cron/checkAddon' => 'Visiosoft\SiteModule\Http\Controller\AddonsController@checkAddon',
        'cron/auto-refresh' => 'Visiosoft\SiteModule\Http\Controller\SiteController@autorefresh',


        //Ajax
        'admin/site/ajax/search-addon' => 'Visiosoft\SiteModule\Http\Controller\Admin\AddonController@searchAddon',
        'admin/site/choose-plan/{id}' => [
            'as' => 'visiosoft.module.site::choose_plan',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\Admin\SubscriptionController@choosePlan'
        ],

        'admin/site/change-plan/{id}/{plan_id}' => [
            'as' => 'visiosoft.module.site::change_plan',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\Admin\SubscriptionController@changePlan'
        ],

        'admin/site/add-bundle' => [
            'as' => 'visiosoft.module.site::admin.add.bundle',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\Admin\SiteController@addBundle'
        ],

        'create-store-domain' => 'Visiosoft\SiteModule\Http\Controller\StoreDomainController@createStoreSubDomianAPI',
    ];

    protected $listeners = [
        SubscriptionCreatedForWebhook::class => [
            CreatedNewSubscriptionForWebhook::class
        ],
        SubscriptionRenewedForWebhook::class => [
            RenewedSubscriptionForWebhook::class
        ],
        SubscriptionSuspendForWebhook::class => [
            SuspendedSubscriptionForWebhook::class
        ],
        SubscriptionFailedForWebhook::class => [
            FailedSubscriptionForWebhook::class
        ],
        SubscriptionDeletedForWebhook::class => [
            DeletedSubscriptionForWebhook::class,
        ],
        SuspendedSubscription::class => [
            SubscriptionSuspended::class
        ],
        UnSuspendedSubscription::class => [
            SubscriptionUnSuspended::class
        ],
        DeletedSubscription::class => [
            SubscriptionDeleted::class,
        ],
        ExpiredSubscription::class => [
            SubscriptionExpired::class
        ],

//        SubscriptionEnabled::class => [
//            UnSuspendSubscription::class
//        ],
//        SubscriptionDeleted::class => [
//            DeletedSubscription::class
//        ],
        PaymentSuccess::class => [
            PaymentSuccessAddon::class,
            \Visiosoft\SiteModule\Bundle\Listener\PaymentSuccess::class
        ],

        SubscriptionCreatedForActivatedUser::class => [
            CreatedNewSubscriptionForActivatedUser::class,
        ],
        UpgradeSubscription::class => [
            UpgradeSubscriptionForWebhook::class,
        ],
        OrderApproved::class => [
            \Visiosoft\SiteModule\Bundle\Listener\OrderApproved::class
        ],
    ];

    protected $bindings = [
        SiteStoreDomainEntryModel::class => StoreDomainModel::class,
        SiteBundlesEntryModel::class => BundleModel::class,
        SiteAddonEntryModel::class => AddonModel::class,
        SiteDomainEntryModel::class => DomainModel::class,
        SiteSiteEntryModel::class => SiteModel::class,
    ];

    protected $singletons = [
        StoreDomainRepositoryInterface::class => StoreDomainRepository::class,
        BundleRepositoryInterface::class => BundleRepository::class,
        AddonRepositoryInterface::class => AddonRepository::class,
        DomainRepositoryInterface::class => DomainRepository::class,
        SiteRepositoryInterface::class => SiteRepository::class,
    ];
}
