<?php namespace Visiosoft\SiteModule\Site\Listener;

use Anomaly\Streams\Platform\Message\MessageBag;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\subscriptions\ErrorUnSuspendSiteForSubscription;
use Visiosoft\SiteModule\Site\Event\subscriptions\UnSuspendedSiteForSubscription;
use Visiosoft\SiteModule\Site\Event\SuspendSite;
use Visiosoft\SubscriptionsModule\Subscription\Event\UnSuspendedSubscription;

class SubscriptionUnSuspended
{
    private $site;
    private $user;
    private $message;

    public function __construct(SiteRepositoryInterface $site, UserRepositoryInterface $user, MessageBag $message)
    {
        $this->site = $site;
        $this->user = $user;
        $this->message = $message;
    }

    public function handle(UnSuspendedSubscription $event)
    {
        $subscription = $event->getSubscription();

        $sites = $this->site->getSiteForSubscription($subscription->id);

        foreach ($sites as $site) {
            $response = array_first(event(new SuspendSite($site, 'false')));
            $url = $site->subdomain_name . "." . $site->type;

            if (!$response['status']) {
                $site->update([
                    'message' => "(error_unsuspend)." . $response['message'],
                    'status' => $response['error'],
                ]);

                event(new ErrorUnSuspendSiteForSubscription($site));

                $this->message->error(trans('visiosoft.module.site::message.error_unsuspend', ['url' => $url]));
            } else {
                $site->update([
                    'suspend_at' => null,
                ]);

                $this->message->success(trans('visiosoft.module.site::message.unsuspended', ['url' => $url]));

                event(new UnSuspendedSiteForSubscription($site));
            }
        }
    }
}
