<?php namespace Visiosoft\SiteModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\StoreDomain\Contract\StoreDomainRepositoryInterface;

class StoreDomainController extends ResourceController
{
    protected $site;
    protected $storeDomain;

    public function __construct(SiteRepositoryInterface $site, StoreDomainRepositoryInterface $storeDomain)
    {
        $this->site = $site;
        $this->storeDomain = $storeDomain;
        parent::__construct();
    }

    public function createStoreSubDomianAPI()
    {
        $status = false;
        if ($this->request->has(['api_key', 'site_slug', 'store_url'])) {
            $site_slug = $this->request->get('site_slug');
            $api_key = $this->request->get('api_key');
            $store_url = $this->request->get('store_url');

            if ($site = $this->site->findBySubdomain($site_slug) and $site->api_token == $api_key) {
                $this->storeDomain->create([
                    'site' => $site,
                    'store_subdomain' => $store_url
                ]);
                $status = true;
            }
        }
        return response()->json($status);
    }
}
