<?php namespace Visiosoft\SiteModule\Site\Form;

use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\BackupStatusChange;
use Visiosoft\SiteModule\Site\Event\BuildSite;
use Visiosoft\SiteModule\Site\Event\BuildSubSite;
use Visiosoft\SiteModule\Site\Event\CheckSubdomain;
use Visiosoft\SiteModule\Site\Event\CreateSiteOnManuel;
use Visiosoft\SiteModule\Site\Event\CreatingSite;
use Visiosoft\SiteModule\Site\Event\ErrorCreateSite;

class SiteFormHandler
{
    public function handle(SiteFormBuilder $builder, MessageBag $message, SiteRepositoryInterface $siteRepository)
    {
        if (!$builder->canSave()) {
            return;
        }

        //Get Entry Before Saving
        $entry_before_saving = $siteRepository->find($builder->getFormEntryId());

        $app = $builder->getPostValue('app');

        $builder->saveForm();

        //Get Entry After Saving
        $entry = $builder->getFormEntry();

        $status = array_first(event(new CheckSubdomain($entry)));

        if ($status) {
            $entry = $this->updateSubdomain($entry);
        }

        if ($builder->getFormMode() === 'create') {

            $site = $builder->getFormEntry();

            if ($app) {
                $app_site = $siteRepository->find($app);

                $entry->setAttribute('type', $app_site->type());
                $entry->save();

                $response = array_first(event(new BuildSubSite($site)));
            } else {
                $response = array_first(event(new BuildSite($site)));
            }

            if (!$response['status']) {
                $site->updateErrorMsg($response['message']);
                $message->error($response['message']);

                event(new ErrorCreateSite($site));
            } else {
                $site->changeStatus('pending');

                event(new CreatingSite($site));

                $response_subscription = array_first(event(new CreateSiteOnManuel($site)));

                if ($response_subscription) {
                    $site->setSubscription($response_subscription->id);
                    $message->success(trans('visiosoft.module.site::message.started_subscription', ['id' => $response_subscription->id]));
                } else {
                    $message->error(trans('visiosoft.module.site::message.failed_start_subscription'));
                }
            }
        }
        //Check Change Backup Status
        if ($entry_before_saving and $entry_before_saving->backup_status != $entry->backup_status) {
            event(new BackupStatusChange($entry));
        }
    }

    public function updateSubdomain($entry)
    {
        for ($i = 1; $i <= 20; $i++) {
            $entry->setAttribute('subdomain_name', $entry->subdomain_name . $i);
            $entry->save();

            $status = array_first(event(new CheckSubdomain($entry)));

            if (!$status) {
                break;
            }
        }

        return $entry;
    }
}
