<?php namespace Visiosoft\SiteModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Entry\EntryModel;
use Illuminate\Support\Facades\DB;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\SiteModule\Addon\Contract\AddonRepositoryInterface;
use Visiosoft\SiteModule\Addon\Table\AddonTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\SiteModule\Site\Event\AddAddonSite;
use Visiosoft\SiteModule\Site\SiteModel;
use Visiosoft\SiteModule\Traits\CheckAddonSiteTrait;

class AddonController extends AdminController
{

    use CheckAddonSiteTrait;
    private $addon;

    public function __construct(AddonRepositoryInterface $addon)
    {
        $this->addon = $addon;
        parent::__construct();
    }

    /**
     * Display an index of existing entries.
     *
     * @param AddonTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(AddonTableBuilder $table)
    {
        $table->setColumns([
            'subdomain', 'addon', 'payment' => [
                'value' => function (EntryModel $entry) {
                    if ($entry->payment) {
                        return "<div class='tag tag-success'><i class='fa fa-check'></i></div>";
                    }
                }
            ],
            'installed' => [
                'value' => function (EntryModel $entry) {
                    if ($entry->installed == 1) {
                        return "<div class='tag tag-success'><i class='fa fa-check'></i></div>";
                    } elseif ($entry->installed == "pending") {
                        return "<div class='tag tag-info'><i class='fa fa-lg fa-clock-o'></i></div>";
                    } elseif ($entry->installed == "error") {
                        return "<div class='tag tag-danger'><i class='fa fa-lg fa-times'></i></div>";
                    }
                }
            ],
            'actions' => [
                'value' => function (EntryModel $entry) {
                    if (!$entry->installed) {
                        return "<a href='/admin/site/addon/installation/" . $entry->id . "' class='btn btn-xs btn-info w-100 fa fa-inbox'> "
                            . trans('visiosoft.module.site::button.install') . "</a>";
                    }
                }
            ],
        ]);
        return $table->render();
    }

    public function AddonInstall(AddonRepositoryInterface $addon, SiteModel $site, $id)
    {
        if (!is_null($addon = $addon->find($id))) {
            if (!is_null($site = $site->find($addon->subdomain_id))) {

                event(new AddAddonSite($site, $addon->addon));
                $addon->payment = true;
                $addon->installed = "pending";
                $addon->save();

                $this->messages->success(trans('streams::installer.installing', ['installing' => $addon->addon]));
                return $this->redirect->to('/admin/site/addon');
            }
        }
    }

    public function getAddonListForSite(CustomFieldRepositoryInterface $cf, $id)
    {
        $result = $this->addon->getAddonsBySite([$id])->pluck('entry_id');
        $addons = [];

        foreach ($result as $addon_id) {
            if ($is_addon = $cf->getAdValueByCustomFieldSlug('addon_composer_name', $addon_id)) {
                $addons[$addon_id] = $is_addon;
            }
        }

        return response()->json(['addons' => $addons]);
    }

    public function checkAddon()
    {
        $this->checkInstalledAddon();
        return back();
    }

    public function searchAddon(CustomFieldRepositoryInterface $customFields)
    {
        $addons = [];

        if ($cf = $customFields->findBySlug('addon_composer_name')) {
            $search_result = DB::table('advs_advs')
                ->where('slug', '!=', "")
                ->leftJoin('cats_category_translations', 'advs_advs.cat1', 'cats_category_translations.entry_id')
                ->where('cf_json', 'like', '%' . $this->request->q . '%')
                ->where(function ($query) {
                    $query->where('cats_category_translations.locale', config('app.locale'))
                        ->orWhere('cats_category_translations.locale', null);

                })
                ->select(['advs_advs.*', 'cats_category_translations.name as category_name'])
                ->groupBy('advs_advs.id')
                ->get();

            foreach ($search_result as $item) {
                if(!$item->cat1)
                {
                    $item->cat1 = 0;
                    $item->category_name = trans('visiosoft.module.site::field.other');
                }
                $addons[$item->cat1]['text'] = $item->category_name;
                $addons[$item->cat1]['children'][$item->id]['id'] = $item->id;
                $addons[$item->cat1]['children'][$item->id]['text'] = $item->slug;
            }

            $addons = array_values($addons);

            foreach ($addons as $key => $group) {
                $addons[$key]['children'] = array_values($addons[$key]['children']);
            }
        }
        return response()->json($addons);
    }
}
