<?php namespace Visiosoft\SiteModule\Domain\Form;


use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\SiteModule\Domain\Event\CreatedDomain;
use Visiosoft\SiteModule\Domain\Event\CreateDomain;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;

class DomainFormHandler
{
    public function handle(DomainFormBuilder $builder, SiteRepositoryInterface $site, MessageBag $message)
    {

        if (!$builder->canSave()) {
            return;
        }

        $post_data = $builder->getPostData();

        $domain = $site->editDomain($post_data['domain']);

        $site = $site->find($post_data['subdomain']);

        if ($site) {
            event(new CreateDomain($site, $domain));

            $builder->saveForm();

            $domain = $builder->getFormEntry();

            event(new CreatedDomain($site, $domain));

            $message->success(trans('streams::message.create_success', ['name' => $domain->domain]));

            return redirect('/admin/site/domain');
        }


    }
}
