<?php namespace Visiosoft\SiteModule\Notifications;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Str;
use Visiosoft\NotificationsModule\Template\Command\CreateTemplate;

class SiteModuleNotificationsTemplateSeeder extends Seeder
{
    use DispatchesJobs;
    public function run()
    {
        if (is_module_installed('visiosoft.module.notifications')) {

            $templates = [
                [
                    'en' => [
                        'message' => '<h4 class="text-center">Guide For Site {site_url}</h4><hr>',
                        'name' => 'Guide For Site',
                        'greeting' => '',
                        'subject' => 'Guide For Site {site_url}! | Openclassify.com'
                    ],
                    'stream' => 'site',
                    'slug' => Str::slug('Guide For Site', '_')
                ],
                [
                    'en' => [
                        'message' => '<tr>
                                     <td class="esd-structure es-p20t es-p20b es-p20r es-p20l" align="left">
                                         <table width="100%" cellspacing="0" cellpadding="0">
                                             <tbody>
                                             <tr>
                                                 <td class="esd-container-frame" width="560" valign="top" align="center">
                                                     <table width="100%" cellspacing="0" cellpadding="0">
                                                         <tbody>
                                                         <tr>
                                                             <td class="esd-block-text es-m-txt-l es-p15t es-p15b es-m-p15t es-m-p0b es-m-p0r es-m-p0l" align="left">
                                                                 <h2><strong>Account Deleted</strong></h2>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070; font-size: 16px;">Hi user,</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p15t" align="left">
                                                                 <p style="color: #707070; font-size: 16px;">Your account has been deleted at your request. Thank you again for being a part of the Openclassify community.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p15t" align="left">
                                                                 <p style="color: #707070;">We hope see you again!</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Thank you in advance,<br>Visiosoft ltd.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer es-p20" style="font-size:0">
                                                                 <table border="0" width="100%" height="100%" cellpadding="0" cellspacing="0">
                                                                     <tbody>
                                                                     <tr>
                                                                         <td style="border-bottom: 0px solid #cccccc; background: none; height: 1px; width: 100%; margin: 0px;"></td>
                                                                     </tr>
                                                                     </tbody>
                                                                 </table>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>',
                        'name' => 'Site Deletion',
                        'subject' => 'Site Deletion | Openclassify.com'
                    ],
                    'stream' => 'site',
                    'slug' => Str::slug('Site Deletion', '_')
                ],
                [
                    'en' => [
                        'message' => '<tr>
                                     <td class="esd-structure es-p20t es-p20b es-p20r es-p20l" align="left">
                                         <table width="100%" cellspacing="0" cellpadding="0">
                                             <tbody>
                                             <tr>
                                                 <td class="esd-container-frame" width="560" valign="top" align="center">
                                                     <table width="100%" cellspacing="0" cellpadding="0">
                                                         <tbody>
                                                         <tr>
                                                             <td class="esd-block-text es-m-txt-l es-p15t es-p15b es-m-p15t es-m-p0b es-m-p0r es-m-p0l" align="left">
                                                                 <h2 style="font-size: 26px;"><strong>Site suspension notice</strong></h2>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070; font-size: 16px;">Hi user,</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p15t" align="left">
                                                                 <p style="color: #707070; font-size: 16px;">Your website will be susbend on 29/4</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070; font-size: 16px;">Lorem Visiosoft<br>Printing and typesetting team</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer" height="29"></td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-button es-p10"><span class="es-button-border" style="background: #ffb600; border-radius: 4px; border-bottom-width: 0px;"><a href class="es-button" target="_blank" style="background: #ffb600; border-color: #ffb600; border-radius: 4px; font-size: 16px; border-width: 10px 35px;">FIND OUT MORE</a></span></td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer es-p20" style="font-size:0">
                                                                 <table border="0" width="100%" height="100%" cellpadding="0" cellspacing="0">
                                                                     <tbody>
                                                                     <tr>
                                                                         <td style="border-bottom: 0px solid #cccccc; background: none; height: 1px; width: 100%; margin: 0px;"></td>
                                                                     </tr>
                                                                     </tbody>
                                                                 </table>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>',
                        'name' => 'Site Suspend',
                        'subject' => 'Site Suspend | Openclassify.com'
                    ],
                    'stream' => 'site',
                    'slug' => Str::slug('Site Suspend', '_')
                ],
                [
                    'en' => [
                        'message' => '<tr>
                                     <td class="esd-structure es-p20t es-p20b es-p20r es-p20l" align="left">
                                         <table width="100%" cellspacing="0" cellpadding="0">
                                             <tbody>
                                             <tr>
                                                 <td class="esd-container-frame" width="560" valign="top" align="center">
                                                     <table width="100%" cellspacing="0" cellpadding="0">
                                                         <tbody>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Hi user,</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p15t" align="left">
                                                                 <p style="color: #707070;">Your site <a target="_blank" href="https://openclassify.com/">testmail.openclassify.com</a> has been set up.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p15t" align="left">
                                                                 <p style="color: #707070;">Your login information<br><br><strong>Email:</strong> info@openclassify.com<br><strong>Password:</strong> admin123<br><br>You can login at&nbsp;<a target="_blank" href="https://openclassify.com/">testmail.openclassify.com/login</a></p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Thank you in advance,<br>Visiosoft ltd.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer es-p20" style="font-size:0">
                                                                 <table border="0" width="100%" height="100%" cellpadding="0" cellspacing="0">
                                                                     <tbody>
                                                                     <tr>
                                                                         <td style="border-bottom: 0px solid #cccccc; background: none; height: 1px; width: 100%; margin: 0px;"></td>
                                                                     </tr>
                                                                     </tbody>
                                                                 </table>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>',
                        'name' => 'Site Set Up',
                        'subject' => 'Site Set Up | Openclassify.com'
                    ],
                    'stream' => 'site',
                    'slug' => Str::slug('Site Set Up', '_')
                ],
                [
                    'en' => [
                        'message' => '<tr>
                                <td class="esd-structure es-p20t es-p20b es-p20r es-p20l" align="left">
                                    <table width="100%" cellspacing="0" cellpadding="0">
                                        <tbody>
                                            <tr>
                                                <td class="esd-container-frame" width="560" valign="top" align="center">
                                                    <table width="100%" cellspacing="0" cellpadding="0">
                                                        <tbody>
                                                            <tr>
                                                                <td class="esd-block-text es-m-txt-l es-p15t es-p15b es-m-p15t es-m-p0b es-m-p0r es-m-p0l" align="left">
                                                                    <h2 style="font-size: 23px;"><strong>Your Website Login Information</strong></h2>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td class="esd-block-text es-p20t" align="left">
                                                                    <p style="color: #707070; font-size: 16px;">Hi {display_name},</p>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td class="esd-block-text es-p15t" align="left">
                                                                    <p style="color: #707070; font-size: 16px;">Front-end Address :<br><a target="_blank" href="{site_url}" style=" font-size: 16px;">{site_url}</a></p>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td class="esd-block-text es-p15t" align="left">
                                                                    <p style="color: #707070; font-size: 16px;">Management Panel :<br><a target="_blank" href="{login_url}" style=" font-size: 16px;">{login_url}</a><br><strong>Username</strong>: {email}<br><strong>Password</strong>: {password}</p>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td class="esd-block-text es-p20t" align="left">
                                                                    <p style="color: #707070; font-size: 16px;">Thank you in advance,<br>Openclassify team</p>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td align="center" class="esd-block-spacer" height="29"></td>
                                                            </tr>
                                                            <tr>
                                                                <td align="center" class="esd-block-button es-p10"><span class="es-button-border" style="background: #ffb600; border-radius: 4px; border-bottom-width: 0px;"><a href="{login_url}" class="es-button" target="_blank" style="background: #ffb600; border-color: #ffb600; border-radius: 4px; font-size: 16px; border-width: 10px 35px;">LOGIN YOUR WEBSITE</a></span></td>
                                                            </tr>
                                                            <tr>
                                                                <td align="center" class="esd-block-spacer es-p20" style="font-size:0">
                                                                    <table border="0" width="100%" height="100%" cellpadding="0" cellspacing="0">
                                                                        <tbody>
                                                                            <tr>
                                                                                <td style="border-bottom: 0px solid #cccccc; background: none; height: 1px; width: 100%; margin: 0px;"></td>
                                                                            </tr>
                                                                        </tbody>
                                                                    </table>
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </td>
                            </tr>',
                        'name' => 'Login Information',
                        'subject' => 'Your Login Information | Openclassify.com'
                    ],
                    'stream' => 'site',
                    'slug' => Str::slug('Login Information', '_')
                ],
                [
                    'en' => [
                        'message' => '<tr>
                                <td class="esd-structure es-p20t es-p20b es-p20r es-p20l" align="left">
                                    <table width="100%" cellspacing="0" cellpadding="0">
                                        <tbody>
                                            <tr>
                                                <td class="esd-container-frame" width="560" valign="top" align="center">
                                                    <table width="100%" cellspacing="0" cellpadding="0">
                                                        <tbody>
                                                            <tr>
                                                                <td class="esd-block-text es-m-txt-l es-p15t es-p40r es-p40l es-m-p0t es-m-p0b es-m-p5r es-m-p5l" align="left">
                                                                    <h2 style="font-size: 24px; text-align: center;"><strong>Next steps</strong></h2>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td class="esd-block-text es-p20t es-p40r es-p40l es-m-p20t es-m-p0b es-m-p5r es-m-p5l es-m-txt-l" align="center">
                                                                    <p style="color: #707070; font-size: 16px;">On average, it takes a store 299 sessions before they get their first order. Increase your discoverability and get you store ready by completing these steps.</p>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td class="esd-block-text es-p15t es-p15b es-p40r es-p40l es-m-p15t es-m-p15b es-m-p5r es-m-p5l" align="left">
                                                                    <p style="color: #707070; font-size: 16px;"><span style="color: #000000; font-size: 18px;">Enable payments</span><br><a target="_blank" style=" font-size: 16px;" href="https://openclassify.com/">Enable your payment details</a> so&nbsp;there are no delays in receiving profits.</p>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td class="esd-block-text es-p15t es-p15b es-p40r es-p40l es-m-p15t es-m-p15b es-m-p5r es-m-p5l" align="left">
                                                                    <p style="color: #707070; font-size: 16px;"><span style="color: #000000; font-size: 18px;">Add title and meta-description</span><br>Use Search Engine Optimization (SEO) to improve your search rankings by <a target="_blank" style=" font-size: 16px;" href="https://openclassify.com/">adding titles</a> to all your store pages.</p>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td class="esd-block-text es-p15t es-p20b es-p40r es-p40l es-m-p15t es-m-p20b es-m-p5r es-m-p5l" align="left">
                                                                    <p style="color: #707070; font-size: 16px;"><span style="color: #000000; font-size: 18px;">Review shipping rates</span><br>Your store is automatically set to ship in your home country and to the rest of the world. <a target="_blank" style=" font-size: 16px;" href="https://openclassify.com/">Review your settings</a> and costs before you start receiving orders.</p>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td align="center" class="esd-block-button es-p10"><span class="es-button-border" style="background: #ffb600; border-radius: 4px; border-bottom-width: 0px;"><a href="https://openclassify.com/" class="es-button" target="_blank" style="background: #ffb600; border-color: #ffb600; border-radius: 4px; font-size: 16px; border-width: 10px 35px;">View the complete checklist</a></span></td>
                                                            </tr>
                                                            <tr>
                                                                <td align="center" class="esd-block-spacer es-p20" style="font-size:0">
                                                                    <table border="0" width="100%" height="100%" cellpadding="0" cellspacing="0">
                                                                        <tbody>
                                                                            <tr>
                                                                                <td style="border-bottom: 0px solid #cccccc; background: none; height: 1px; width: 100%; margin: 0px;"></td>
                                                                            </tr>
                                                                        </tbody>
                                                                    </table>
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </td>
                            </tr>',
                        'name' => 'Guide For Newly Opened Sites',
                        'subject' => 'Next Steps | Openclassify.com'
                    ],
                    'stream' => 'site',
                    'slug' => Str::slug('Guide For Newly Opened Sites', '_')
                ],
                [
                    'en' => [
                        'message' => '<h3 class="text-center">Your {url} site is suspended!</h3><h5 class="text-center">For a more elegant store, visit our Modules and Themes pages.</h5><p class="text-center">Thank You.</p><h6 class="text-center">Openclassify Team</h6>',
                        'name' => 'Suspended Site By Admin',
                        'greeting' => 'Hi {display_name}',
                        'subject' => 'Your {url} site is suspended!'
                    ],
                    'stream' => 'site',
                    'slug' => Str::slug('Suspended Site By Admin', '_')
                ],
                [
                    'en' => [
                        'message' => '<h3 class="text-center">Your {url} site is unsuspended!</h3><h5 class="text-center">For a more elegant store, visit our Modules and Themes pages.</h5><p class="text-center">Thank You.</p><h6 class="text-center">Openclassify Team</h6>',
                        'name' => 'UnSuspended Site By Admin',
                        'greeting' => 'Hi {display_name}',
                        'subject' => 'Your {url} site is unsuspended!'
                    ],
                    'stream' => 'site',
                    'slug' => Str::slug('UnSuspended Site By Admin', '_')
                ],
                [
                    'en' => [
                        'message' => '<h3 class="text-center">Your {url} site is suspended!</h3><h5 class="text-center">For a more elegant store, visit our Modules and Themes pages.</h5><p class="text-center">Thank You.</p><h6 class="text-center">Openclassify Team</h6>',
                        'name' => 'Suspended Site For Webhook',
                        'greeting' => 'Hi {display_name}',
                        'subject' => 'Your {url} site is suspended!'
                    ],
                    'stream' => 'site',
                    'slug' => Str::slug('Suspended Site For Webhook', '_')
                ],
                [
                    'en' => [
                        'message' => '<h3 class="text-center">this {url} site suspend error!</h3><p class="text-center">Thank You.</p><h6 class="text-center">Openclassify Team</h6>',
                        'name' => 'Error Suspend Site For Webhook',
                        'greeting' => 'Hi {display_name}',
                        'subject' => 'this {url} site suspend error!'
                    ],
                    'stream' => 'site',
                    'slug' => Str::slug('Error Suspend Site For Webhook', '_')
                ],
                [
                    'en' => [
                        'message' => '<h3 class="text-center">this {url} site unsuspend error!</h3><p class="text-center">Thank You.</p><h6 class="text-center">Openclassify Team</h6>',
                        'name' => 'Error UnSuspend Site For Webhook',
                        'greeting' => 'Hi {display_name}',
                        'subject' => 'this {url} site unsuspend error!'
                    ],
                    'stream' => 'site',
                    'slug' => Str::slug('Error UnSuspend Site For Webhook', '_')
                ],
                [
                    'en' => [
                        'message' => '<h3 class="text-center">this {url} site building error!</h3><p class="text-center">Thank You.</p><h6 class="text-center">Openclassify Team</h6>',
                        'name' => 'Error Building Site For Webhook',
                        'greeting' => 'Hi {display_name}',
                        'subject' => 'this {url} site building error!'
                    ],
                    'stream' => 'site',
                    'slug' => Str::slug('Error Building Site For Webhook', '_')
                ],
                [
                    'en' => [
                        'message' => '<h3 class="text-center">this {url} site create error!{message}</h3><p class="text-center">Thank You.</p><h6 class="text-center">Openclassify Team</h6>',
                        'name' => 'Error Create Site By Admin',
                        'greeting' => 'Hi {display_name}',
                        'subject' => 'this {url} site create error!{message}'
                    ],
                    'stream' => 'site',
                    'slug' => Str::slug('Error Create Site By Admin', '_')
                ],
                [
                    'en' => [
                        'message' => '<h4 class="text-center">Your site {site_url} setup completed!</h4><hr><p class="text-center"><strong>Your Login Information</strong></p><h5 class="text-center">{email}</h5><h5 class="text-center">{password}</h5><p class="text-center"><strong>You can log in at&nbsp;<a href="{login_url}">{login_url}</a>.</strong></p><p class="text-center">Thank You.</p><h6 class="text-center">Openclassify Team</h6>',
                        'name' => 'Completed Installation Site',
                        'greeting' => 'Hi {display_name}',
                        'subject' => 'Your site {site_url} setup completed! | Openclassify.com'
                    ],
                    'stream' => 'site',
                    'slug' => Str::slug('Completed Installation Site', '_')
                ],
                [
                    'en' => [
                        'message' => '<h4 class="text-center">Your site {site_url} setup completed!</h4><hr><p class="text-center"><strong>Your Login Information</strong></p><h5 class="text-center">{email}</h5><h5 class="text-center">{password}</h5><p class="text-center"><strong>You can log in at&nbsp;<a href="{login_url}">{login_url}</a>.</strong></p><p class="text-center">Thank You.</p><h6 class="text-center">Openclassify Team</h6>',
                        'name' => 'Completed Installation Site(Admin)',
                        'greeting' => 'Hi',
                        'subject' => 'Your site {site_url} setup completed! | Openclassify.com'
                    ],
                    'stream' => 'site',
                    'slug' => Str::slug('Completed Installation Site(Admin)', '_')
                ],
                [
                    'en' => [
                        'message' => '<h3 class="text-center">{domain} domain has been added to {url} </h3><p></p><h6 class="text-center">Openclassify Team</h6>',
                        'name' => 'Added Domain Site',
                        'greeting' => 'Hi {display_name}',
                        'subject' => '{domain} domain has been added to {url} | Openclassify.com'
                    ],
                    'stream' => 'site',
                    'slug' => Str::slug('Added Domain Site', '_')
                ],
                [
                    'en' => [
                        'message' => '<h3 class="text-center">{domain} domain has been added to {url} </h3><p></p><h6 class="text-center">Openclassify Team</h6>',
                        'name' => 'Added Domain Site(Admin)',
                        'greeting' => 'Hi',
                        'subject' => '{domain} domain has been added to {url} | Openclassify.com'
                    ],
                    'stream' => 'site',
                    'slug' => Str::slug('Added Domain Site(Admin)', '_')
                ],
                [
                    'en' => [
                        'message' => '<h4 class="text-center">Your Openclassify.com account has been successfully created.</h4><hr><p class="text-center"><strong>Your Login Information</strong></p><h5 class="text-center">{email}</h5><h5 class="text-center">{password}</h5><p class="text-center"><strong>You can login at&nbsp;<a href="{login_url}">{login_url}</a>.</strong></p><p class="text-center">Thank You.</p><h6 class="text-center">Openclassify Team</h6>',
                        'name' => 'Created User For Demo',
                        'greeting' => 'Hi {display_name}',
                        'subject' => 'Openclassify.com Giriş Bilgileriniz !'
                    ],
                    'stream' => 'site',
                    'slug' => Str::slug('Created User For Demo', '_')
                ],
                [
                    'en' => [
                        'message' => '<h3 class="text-center">The plug-in "{addon_name}" that you purchased for {site_url} has been installed!</h3><p></p><h6 class="text-center">Openclassify Team</h6>',
                        'name' => 'Installed Addon',
                        'greeting' => 'Hi {display_name}',
                        'subject' => 'The plug-in you purchased for {site_url} has been installed! | Openclassify.com'
                    ],
                    'stream' => 'site',
                    'slug' => Str::slug('Installed Addon', '_')
                ],
                [
                    'en' => [
                        'message' => '<h3 class="text-center">{domain} domain has been deleted to {url} </h3><p></p><h6 class="text-center">Openclassify Team</h6>',
                        'name' => 'Deleted Domain Site',
                        'greeting' => 'Hi {display_name}',
                        'subject' => '{domain} domain has been deleted to {url} | Openclassify.com'
                    ],
                    'stream' => 'site',
                    'slug' => Str::slug('Deleted Domain Site', '_')
                ]
            ];


            foreach ($templates as $template) {
                $this->dispatchNow(new CreateTemplate($template));
            }
        }
    }
}