<?php namespace Visiosoft\SiteModule\Site\Table\Handler;

use Anomaly\Streams\Platform\Message\MessageBag;
use Anomaly\Streams\Platform\Ui\Table\Component\Action\ActionHandler;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\SuspendedSite;
use Visiosoft\SiteModule\Site\Event\SuspendSite;
use Visiosoft\SiteModule\Site\Event\UnSuspendedSite;


class unSuspend extends ActionHandler
{
    public function handle(SiteRepositoryInterface $siteRepository, array $selected, MessageBag $message)
    {
        foreach ($selected as $id) {
            if ($site = $siteRepository->findSuspend($id)) {
                $response = array_first(event(new SuspendSite($site, 'false')));

                $url = $site->getUrl();

                if (!$response['status']) {

                    $site->updateErrorMsg($response['message']);

                    $message->error(trans('visiosoft.module.site::message.error_unsuspend', ['url' => $url]));
                } else {
                    $site->unsuspend();

                    $message->success(trans('visiosoft.module.site::message.unsuspended', ['url' => $url]));

                    event(new UnSuspendedSite($site));
                }
            }
        }
    }
}