<?php namespace Visiosoft\SiteModule\Site\Table\Handler;

use Anomaly\Streams\Platform\Message\MessageBag;
use Anomaly\Streams\Platform\Ui\Table\Component\Action\ActionHandler;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\SuspendedSite;
use Visiosoft\SiteModule\Site\Event\SuspendSite;


class SoftDelete extends ActionHandler
{
    public function handle(SiteRepositoryInterface $siteRepository, array $selected, MessageBag $message)
    {
        foreach ($selected as $id) {
            $site = $siteRepository->find($id);
            if ($site) {
                $site->delete();

                $url = $site->getUrl();

                $response = array_first(event(new SuspendSite($site, 'true')));

                if (!$response['status']) {
                    $site->updateErrorMsg($response['message']);

                    $message->error(trans('visiosoft.module.site::message.error_suspend', ['url' => $url]));
                } else {
                    $site->suspend();

                    $message->success(trans('visiosoft.module.site::message.suspended', ['url' => $url]));

                    event(new SuspendedSite($site));
                }
            }
        }
    }
}