<?php namespace Visiosoft\SiteModule\Site\Table\Handler;

use Anomaly\Streams\Platform\Ui\Table\Component\Action\ActionHandler;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\DeleteSite;


class Delete extends ActionHandler
{
    public function handle(SiteRepositoryInterface $siteRepository, array $selected)
    {
        foreach ($selected as $id) {

            if ($site = $siteRepository->findTerminate($id)) {
                $response = array_first(event(new DeleteSite($site)));
                $url = $site->getUrl();

                if ($response['status']) {
                    $this->messages->success(trans('visiosoft.module.site::message.deleted', ['name' => $url]));
                } else {
                    $this->messages->error($response['message']."=>".$url);
                }
                $site->terminate();
            }
        }
    }
}