<?php namespace Visiosoft\SiteModule\Site\Listener\webhook;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\BuildSite;
use Visiosoft\SiteModule\Site\Event\webhook\ErrorBuildingSiteForWebhook;
use Visiosoft\SubscriptionsModule\Subscription\Event\webhook\SubscriptionCreatedForWebhook;

class CreatedNewSubscriptionForWebhook
{
    private $site;
    private $user;

    public function __construct(SiteRepositoryInterface $site, UserRepositoryInterface $user)
    {
        $this->site = $site;
        $this->user = $user;
    }

    public function handle(SubscriptionCreatedForWebhook $event)
    {
        $parameters = $event->getParameters();
        $parameters_sent = json_decode($parameters['passthrough'], true);
        if (isset($parameters_sent['storename'])) {
            $subdomain = $parameters_sent['storename'];

            //Check Site
            if ($site = $this->site->findBySubdomain($subdomain)
                and $site->status != "completed") {
                $site->update([
                    'subscription_id' => $event->getSubscription()->id,
                    'status' => 'pending'
                ]);

                $response = array_first(event(new BuildSite($site)));

                if (!$response['status']) {
                    $site->update([
                        'message' => $response['message'],
                        'status' => 'error'
                    ]);

                    event(new ErrorBuildingSiteForWebhook($site));
                }
            }
        }
    }
}
