<?php namespace Visiosoft\SiteModule\Site\Handler;


use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SubscriptionsModule\Subscription\Contract\SubscriptionRepositoryInterface;

class CheckCreateSiteForSubscription
{
    private $type;
    private $id;

    public function __construct($id, $type)
    {
        $this->type = $type;
        $this->id = $id;

    }

    public function handle(SiteRepositoryInterface $site, SubscriptionRepositoryInterface $subscription)
    {
        $subscription = $subscription->checkSubscription($this->id);

        //Check Subscription
        if ($subscription) {
            $sites = $site->getSiteForSubscription($subscription->id);

            //Get Features For Subscription
            $subscriptionsFeatures = $subscription->plan->feature->pluck('value', 'id')->all();

            if (count($subscriptionsFeatures) > 0) {

                //Site oluşturma özellikleri
                $createLimitFeatures = setting_value('visiosoft.module.subscriptions::create_limit_features');
                foreach ($createLimitFeatures as $createLimit) {

                    if (array_key_exists($createLimit, $subscriptionsFeatures)) {

                        if ($subscriptionsFeatures[$createLimit] > count($sites)) {

                            //Return type getLimit
                            if ($this->type == "getLimit") {
                                return $subscriptionsFeatures[$createLimit];
                            }
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }
}