<?php namespace Visiosoft\SiteModule\Site\AddSslForm;

use Visiosoft\SiteModule\Domain\Contract\DomainRepositoryInterface;

class AddSslFormFields
{
    public function handle(AddSslFormBuilder $builder, DomainRepositoryInterface $domainRepository)
    {

        $domains = $domainRepository->getDomainsBySite([request('site')])->pluck('domain','id')->all();

        $builder->setFields(
            [
                'domains' => [
                    'type' => 'anomaly.field_type.checkboxes',
                    'config' => [
                        'options' => $domains
                    ],
                ],
            ]
        );
    }
}
