<?php namespace Visiosoft\SiteModule\Http\Controller\Admin;

use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\SiteModule\Site\AddAddonForm\AddAddonFormBuilder;
use Visiosoft\SiteModule\Site\AddBundleForm\AddBundleFormBuilder;
use Visiosoft\SiteModule\Site\AddSslForm\AddSslFormBuilder;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\BuildSite;
use Visiosoft\SiteModule\Site\Event\CheckActivatedSite;
use Visiosoft\SiteModule\Site\Event\CompletedInstallationSite;
use Visiosoft\SiteModule\Site\Event\CreateSiteOnManuel;
use Visiosoft\SiteModule\Site\Event\SendEmailTemplate;
use Visiosoft\SiteModule\Site\Form\SiteFormBuilder;
use Visiosoft\SiteModule\Site\Table\SiteTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class SiteController extends AdminController
{
    private $site;

    public function __construct(SiteRepositoryInterface $site)
    {
        $this->site = $site;
        parent::__construct();
    }

    public function index(SiteTableBuilder $table)
    {
        return $table->render();
    }

    public function choose(TemplateRepositoryInterface $templateRepository, $id)
    {
        return $this->view->make('module::admin/site/choose', ['templates' => $templateRepository->all(), 'id' => $id]);
    }

    public function sendEmail($id, $slug)
    {
        try {
            $site = $this->site->find($id);

            event(new SendEmailTemplate($site, $slug));

            $this->messages->success('Email send successfully!');
        } catch (\Exception $e) {
            $this->messages->error($e->getMessage());
        }

        return redirect('admin/site');
    }

    public function create(SiteFormBuilder $form)
    {
        return $form->render();
    }

    public function addAddon(AddAddonFormBuilder $form)
    {
        return $form->render();
    }

    public function addSSL(AddSslFormBuilder $form)
    {
        return $form->render();
    }

    public function addBundle(AddBundleFormBuilder $form)
    {
        return $form->render();
    }

    public function check()
    {
        $activated = array();
        $pending_sites = $this->site->getPendingSites();
        foreach ($pending_sites as $site) {
            $result = array_first(event(new CheckActivatedSite($site)));
            if ($result) {
                $site->changeStatus('completed');

                $activated[] = $site->subdomain_name;

                event(new CompletedInstallationSite($site));
            }
        }
        return $this->redirect->to('/admin/site');
    }

    public function completeOnManuel($id)
    {
        //Check Site
        if ($site = $this->site->find($id)
            and $site->status == "incomplete") {

            $response = array_first(event(new BuildSite($site)));

            if (!$response['status']) {
                $site->updateErrorMsg($response['message']);
                $this->messages->error([$response['message']]);
            } else {
                $site->changeStatus('pending');

                $response_subscription = array_first(event(new CreateSiteOnManuel($site)));

                $this->messages->success(trans('visiosoft.module.site::message.started_on_manual'));

                if ($response_subscription) {
                    $site->setSubscription($response_subscription->id);
                    $this->messages->success(trans('visiosoft.module.site::message.started_subscription', ['id' => $response_subscription->id]));
                } else {
                    $this->messages->error(trans('visiosoft.module.site::message.failed_start_subscription'));
                }
            }
        }
        return back();
    }

    public function edit(SiteFormBuilder $builder, $id)
    {
        return $builder->render($id);
    }
}
