<?php namespace Visiosoft\SiteModule\Command;

use Anomaly\Streams\Platform\Message\MessageBag;

class CheckSite
{
    protected $url;

    public function __construct($url)
    {
        $this->url = $url;
    }

    public function handle(MessageBag $message)
    {
        $response = [
            'verify' => false,
            'verify_ssl' => false,
        ];

        try {
            $response['verify'] = $this->check();
            $response['verify_ssl'] = $this->check(true);

        } catch (\Exception $exception) {
            $message->error([$exception->getMessage()]);
        }

        return $response;

    }

    public function check($ssl = false)
    {
        $ch = curl_init($this->url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);

        if (!$ssl) {
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        }


        curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        return $httpcode == 200 ? true : false;
    }
}
