<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Visiosoft\SiteModule\Site\SiteModel;

class VisiosoftModuleSiteCreateStoreDomainStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'store_domain',
        'title_column' => 'id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    protected $fields = [
        'site' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => SiteModel::class,
            ]
        ],
        'store_subdomain' => 'anomaly.field_type.text'
    ];
    protected $assignments = [
        'site' => [
            'required' => true,
        ],
        'store_subdomain' => [
            'required' => true,
        ],
    ];

}
