<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Visiosoft\SiteModule\Site\SiteModel;

class VisiosoftModuleSiteCreateAddonTrialStream extends Migration
{
    protected $delete = true;

    protected $stream = [
        'slug' => 'addon_trial',
        'title_column' => 'id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    protected $fields = [
        'site' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => SiteModel::class,
            ]
        ],
        'trialed_addon' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\AdvsModule\Adv\AdvModel::class,
            ]
        ],
        "expires_at" => 'anomaly.field_type.datetime',
        'removed' => 'anomaly.field_type.boolean',
    ];

    protected $assignments = [
        'site' => [
            'required' => true,
        ],
        'trialed_addon' => [
            'required' => true,
        ],
        'expires_at' => [
            'required' => true,
        ],
        'removed',
    ];
}
