<?php namespace Visiosoft\SiteModule\Site\Table;

use Anomaly\Streams\Platform\Ui\Table\Component\View\Type\All;
use Anomaly\Streams\Platform\Ui\Table\Component\View\Type\Trash;
use Anomaly\Streams\Platform\Ui\Table\TableBuilder;
use Visiosoft\SiteModule\Site\Table\Handler\Delete;
use Visiosoft\SiteModule\Site\Table\Handler\SoftDelete;
use Visiosoft\SiteModule\Site\Table\Handler\Suspend;
use Visiosoft\SiteModule\Site\Table\Handler\unSuspend;
use Visiosoft\SiteModule\Site\Table\Handler\Update;

class SiteTableBuilder extends TableBuilder
{
    protected $views = [
        'all' => [
            'slug' => 'all',
            'text' => 'streams::view.all',
            'view' => All::class,
        ],
        'trash' => [
            'slug' => 'trash',
            'text' => 'streams::view.trash',
            'view' => Trash::class,
            'buttons' => [],
            'actions' => [
                'delete' => [
                    'text' => 'streams::button.force_delete',
                    'handler' => Delete::class,
                ],
                'restore' => [
                    'handler' => unSuspend::class,
                ],
            ],
            'options' => [
                'sortable' => false,
            ],
        ],
    ];

    protected $actions = [
        'delete' => [
            'handler' => SoftDelete::class,
        ],
        'update' => [
            'handler' => Update::class,
            'icon' => 'refresh',
            'text' => 'visiosoft.module.site::button.update',
            'type' => 'info'
        ],
        'suspend' => [
            'handler' => Suspend::class,
            'text' => 'visiosoft.module.site::button.suspend',
            'icon' => 'fa fa-eye-slash'
        ],
        'unSuspend' => [
            'handler' => unSuspend::class,
            'text' => 'visiosoft.module.site::button.unSuspend',
            'icon' => 'fa fa-eye',
            'type' => 'primary'
        ]
    ];

    protected $options = [
        'order_by' => [
            'id' => 'DESC',
        ],
    ];

    protected $assets = [
        'scripts.js' => [
            'visiosoft.module.site::js/admin/filter-assign.js',
        ],
        'styles.css' => [
            'visiosoft.module.site::css/admin/filter-assign.css',
        ],
    ];
}
