<?php namespace Visiosoft\SiteModule\Site\Table\Handler;

use Anomaly\Streams\Platform\Message\MessageBag;
use Anomaly\Streams\Platform\Ui\Table\Component\Action\ActionHandler;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\SuspendedSite;
use Visiosoft\SiteModule\Site\Event\SuspendSite;
use Visiosoft\SiteModule\Site\Event\UnSuspendedSite;


class unSuspend extends ActionHandler
{
    public function handle(SiteRepositoryInterface $site, array $selected,MessageBag $message)
    {
        foreach ($selected as $id) {
            $site = $site->newQuery()
                ->whereNotNull('suspend_at')
                ->whereIn('status', ['completed', 'pending'])
                ->find($id);

            if ($site) {
                $response = array_first(event(new SuspendSite($site, 'false')));
                $url = $site->subdomain_name . "." . $site->type;

                if (!$response['status']) {
                    $site->update([
                        'message' => "(error_unsuspend)." . $response['message'],
                        'status' => $response['error'],
                    ]);

                    $message->error(trans('visiosoft.module.site::message.error_unsuspend', ['url' => $url]));
                } else {
                    $site->update(['suspend_at' => date('Y-m-d H:i:s'),]);

                    $message->success(trans('visiosoft.module.site::message.unsuspended', ['url' => $url]));

                    event(new UnSuspendedSite($site));
                }
            }
        }
    }
}