<?php namespace Visiosoft\SiteModule\Site\Table\Handler;

use Anomaly\Streams\Platform\Ui\Table\Component\Action\ActionHandler;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\DeleteSite;


class Delete extends ActionHandler
{
    public function handle(SiteRepositoryInterface $site, array $selected)
    {
        foreach ($selected as $id) {

            if ($site = $site->find($id) and is_null($site->deletedCwp) and $site->suspend_at) {
                $response = array_first(event(new DeleteSite($site)));

                if ($response['status']) {
                    $url = $site->subdomain_name . "." . $site->type;
                    $site->update(['deletedCwp' => date('Y-m-d H:i:s')]);
                    $this->messages->success(trans('visiosoft.module.site::message.deleted', ['name' => $url]));
                }
            }
        }
    }
}